﻿Imports System.Web.DynamicData

Partial Class ListDetails
    Inherits System.Web.UI.Page

        
    Protected Sub Page_Init(ByVal sender As Object, ByVal e As EventArgs)
        DynamicDataManager1.RegisterControl(GridView1, true)
        DynamicDataManager1.RegisterControl(DetailsView1)
    End Sub
    
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
        Dim table As MetaTable = GridDataSource.GetTable
        Title = table.DisplayName
        GridDataSource.Include = table.ForeignKeyColumnsNames
        DetailsDataSource.Include = table.ForeignKeyColumnsNames
        ' 如果表是只读的，则禁用各选项
        If table.IsReadOnly Then
            DetailsPanel.Visible = false
            GridView1.AutoGenerateSelectButton = false
            GridView1.AutoGenerateEditButton = false
            GridView1.AutoGenerateDeleteButton = false
        End If
    End Sub
    
    Protected Sub OnGridViewDataBound(ByVal sender As Object, ByVal e As EventArgs)
        If (GridView1.Rows.Count = 0) Then
            DetailsView1.ChangeMode(DetailsViewMode.Insert)
        End If
    End Sub
    
    Protected Sub OnFilterSelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs)
        GridView1.EditIndex = -1
        GridView1.PageIndex = 0
        DetailsView1.ChangeMode(DetailsViewMode.ReadOnly)
    End Sub
    
    Protected Sub OnGridViewRowEditing(ByVal sender As Object, ByVal e As EventArgs)
        DetailsView1.ChangeMode(DetailsViewMode.ReadOnly)
    End Sub
    
    Protected Sub OnGridViewSelectedIndexChanging(ByVal sender As Object, ByVal e As EventArgs)
        GridView1.EditIndex = -1
        DetailsView1.ChangeMode(DetailsViewMode.ReadOnly)
    End Sub
    
    Protected Sub OnGridViewRowCreated(ByVal sender As Object, ByVal e As GridViewRowEventArgs)
        SetDeleteConfirmation(e.Row)
    End Sub
    
    Protected Sub OnGridViewRowDeleted(ByVal sender As Object, ByVal e As GridViewDeletedEventArgs)
        DetailsView1.DataBind
    End Sub
    
    Protected Sub OnGridViewRowUpdated(ByVal sender As Object, ByVal e As GridViewUpdatedEventArgs)
        DetailsView1.DataBind
    End Sub
    
    Protected Sub OnDetailsViewItemDeleted(ByVal sender As Object, ByVal e As DetailsViewDeletedEventArgs)
        GridView1.DataBind
    End Sub
    
    Protected Sub OnDetailsViewItemUpdated(ByVal sender As Object, ByVal e As DetailsViewUpdatedEventArgs)
        GridView1.DataBind
    End Sub
    
    Protected Sub OnDetailsViewItemInserted(ByVal sender As Object, ByVal e As DetailsViewInsertedEventArgs)
        GridView1.DataBind
    End Sub
    
    Protected Sub OnDetailsViewModeChanging(ByVal sender As Object, ByVal e As DetailsViewModeEventArgs)
        If (e.NewMode <> DetailsViewMode.ReadOnly) Then
            GridView1.EditIndex = -1
        End If
    End Sub
    
    Protected Sub OnDetailsViewPreRender(ByVal sender As Object, ByVal e As EventArgs)
        Dim rowCount As Integer = DetailsView1.Rows.Count
        If (rowCount > 0) Then
            SetDeleteConfirmation(DetailsView1.Rows((rowCount - 1)))
        End If
    End Sub
    
    Private Sub SetDeleteConfirmation(ByVal row As TableRow)
        For Each c As Control In row.Cells(0).Controls
            If (TypeOf c Is LinkButton) Then
                Dim btn As LinkButton = CType(c,LinkButton)
                If (btn.CommandName = DataControlCommands.DeleteCommandName) Then
                    btn.OnClientClick = "return confirm('Are you sure you want to delete this item?');"
                End If
            End If
        Next
    End Sub


End Class
